﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using AZVIC.Ei8htPOS.Utilities;
using System.Data;

namespace AZVIC.Ei8htPOS.Entities
{
    public class Layouts
    {

        public Layouts()
        {

        }

        public Layouts(IDataReader myDataRecord)
        {
            TableID = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("UniqueID")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("UniqueID"));
            TableName = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TableName")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("TableName"));
            TableCapacity = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TableCapacity")) ? 0 : myDataRecord.GetInt32(myDataRecord.GetOrdinal("TableCapacity"));
            CreatedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("CreatedDate"));
            ModifiedDate = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedDate")) ? DateTime.MinValue : myDataRecord.GetDateTime(myDataRecord.GetOrdinal("ModifiedDate"));
            CreatedBy = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("CreatedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("CreatedBy"));
            ModifiedBy = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("ModifiedBy")) ? Guid.Empty : myDataRecord.GetGuid(myDataRecord.GetOrdinal("ModifiedBy"));
            IsActive = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("IsActive")) ? false : myDataRecord.GetBoolean(myDataRecord.GetOrdinal("IsActive"));
            TableType = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TableType")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("TableType"));
            TablePosition = myDataRecord.IsDBNull(myDataRecord.GetOrdinal("TablePosition")) ? string.Empty : myDataRecord.GetString(myDataRecord.GetOrdinal("TablePosition"));
        }

        [DataObjectField(true, false, false)]
        public Guid TableID { get; set; }

        public string TableType { get; set; }

        public string TablePosition { get; set; }

        public string TableName { get; set; }

        public int TableCapacity { get; set; }

        public DateTime CreatedDate { get; set; }

        public DateTime ModifiedDate { get; set; }

        public Guid CreatedBy { get; set; }

        public Guid ModifiedBy { get; set; }

        public bool IsActive { get; set; }
    }
}
